/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Font;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.das2.graph.DasAxis;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.LegendPosition;
import org.das2.util.LoggerManager;

public class DomOps {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");
    public static final String OPTION_FIX_LAYOUT_HIDE_TITLES = "hideTitles";
    public static final String OPTION_FIX_LAYOUT_HIDE_TIME_AXES = "hideTimeAxes";
    public static final String OPTION_FIX_LAYOUT_HIDE_Y_AXES = "hideYAxes";
    public static final String OPTION_FIX_LAYOUT_MOVE_LEGENDS_TO_OUTSIDE_NE = "moveLegendsToOutsideNE";
    public static final String OPTION_FIX_LAYOUT_VERTICAL_SPACING = "verticalSpacing";
    public static final String OPTION_FIX_LAYOUT_HORIZONTAL_SPACING = "horizontalSpacing";

    public static void swapPosition(Plot a, Plot b) {
        if (a == b) {
            return;
        }
        if (a.controller != null) {
            a.controller.dom.options.setAutolayout(false);
        }
        String trowid = a.getRowId();
        String tcolumnid = a.getColumnId();
        boolean txtv = a.getXaxis().isDrawTickLabels();
        boolean tytv = a.getYaxis().isDrawTickLabels();
        String ticksUriA = a.getTicksURI();
        String ticksUriB = b.getTicksURI();
        a.setTicksURI(ticksUriB);
        b.setTicksURI(ticksUriA);
        String ticksUriALabels = a.getEphemerisLabels();
        String ticksUriBLabels = b.getEphemerisLabels();
        a.setTicksURI(ticksUriBLabels);
        b.setTicksURI(ticksUriALabels);
        a.setRowId(b.getRowId());
        a.setColumnId(b.getColumnId());
        a.getXaxis().setDrawTickLabels(b.getXaxis().isDrawTickLabels());
        a.getYaxis().setDrawTickLabels(b.getYaxis().isDrawTickLabels());
        b.setRowId(trowid);
        b.setColumnId(tcolumnid);
        b.getXaxis().setDrawTickLabels(txtv);
        b.getYaxis().setDrawTickLabels(tytv);
        if (a.controller != null) {
            a.controller.dom.controller.waitUntilIdle();
            a.controller.dom.options.setAutolayout(true);
        }
    }

    public static Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, Object direction) {
        Application application = srcPlot.getController().getApplication();
        ApplicationController ac = application.getController();
        Plot that = ac.addPlot(direction);
        that.getController().setAutoBinding(false);
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = ac.findBinding(application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                ac.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                ac.bind(application, "timeRange", that.getXaxis(), "range");
            }
        }
        if (bindy) {
            ac.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
        }
        return that;
    }

    public static List<PlotElement> copyPlotElements(Plot srcPlot, Plot dstPlot) {
        ApplicationController ac = srcPlot.getController().getApplication().getController();
        List<PlotElement> srcElements = ac.getPlotElementsFor(srcPlot);
        ArrayList<PlotElement> newElements = new ArrayList<PlotElement>();
        for (PlotElement srcElement : srcElements) {
            PlotElement newp;
            if (!srcElement.getComponent().equals("")) {
                if (srcElement.getController().getParentPlotElement() != null) continue;
                newp = ac.copyPlotElement(srcElement, dstPlot, null);
                newElements.add(newp);
                continue;
            }
            newp = ac.copyPlotElement(srcElement, dstPlot, null);
            newElements.add(newp);
            List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
            DataSourceFilter dsf1 = ac.getDataSourceFilterFor(newp);
            for (PlotElement k : srcKids) {
                if (!srcElements.contains(k)) continue;
                PlotElement kidp = ac.copyPlotElement(k, dstPlot, dsf1);
                kidp.getController().setParentPlotElement(newp);
                newElements.add(kidp);
            }
        }
        return newElements;
    }

    public static Plot copyPlotAndPlotElements(Plot srcPlot, boolean copyPlotElements, boolean bindx, boolean bindy, Object direction) {
        Plot dstPlot = DomOps.copyPlot(srcPlot, bindx, bindy, direction);
        if (copyPlotElements) {
            DomOps.copyPlotElements(srcPlot, dstPlot);
        }
        return dstPlot;
    }

    public static Column getOrCreateSelectedColumn(Application dom, List<Plot> selectedPlots, boolean create) {
        HashSet<String> n = new HashSet<String>();
        for (Plot p : selectedPlots) {
            n.add(p.getColumnId());
        }
        if (n.size() == 1) {
            return (Column)DomUtil.getElementById(dom, (String)n.iterator().next());
        }
        if (create) {
            Canvas c = dom.getCanvases(0);
            Column col = c.getController().addColumn();
            col.setLeft("0%");
            col.setRight("100%");
            return col;
        }
        return null;
    }

    public static Row getOrCreateSelectedRow(Application dom, List<Plot> selectedPlots, boolean create) {
        HashSet<String> n = new HashSet<String>();
        for (Plot p : selectedPlots) {
            if (n.contains(p.getRowId())) continue;
            n.add(p.getRowId());
        }
        if (n.size() == 1) {
            return (Row)DomUtil.getElementById(dom, (String)n.iterator().next());
        }
        if (create) {
            Row r;
            Iterator iter = n.iterator();
            Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)iter.next());
            Row rmin = r;
            int i = 1;
            while (iter.hasNext()) {
                r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)iter.next());
                if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                    rmax = r;
                }
                if (r.getController().getDasRow().getDMinimum() < rmin.getController().getDasRow().getDMinimum()) {
                    rmin = r;
                }
                ++i;
            }
            Canvas c = dom.getCanvases(0);
            Row row = c.getController().addRow();
            row.setTop(rmin.getTop());
            row.setBottom(rmax.getBottom());
            return row;
        }
        return null;
    }

    public static Plot[] bottomAndTopMostPlot(Application dom, List<Plot> plots) {
        Row r;
        Plot pmax = plots.get(0);
        Plot pmin = plots.get(0);
        Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), pmax.getRowId());
        Row rmin = r;
        for (Plot p : plots) {
            r = (Row)DomUtil.getElementById(dom.getCanvases(0), p.getRowId());
            if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                rmax = r;
                pmax = p;
            }
            if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
            rmin = r;
            pmin = p;
        }
        return new Plot[]{pmax, pmin};
    }

    public static Plot[] bottomAndTopMostPlot(Application dom, Plot[] plots) {
        return DomOps.bottomAndTopMostPlot(dom, Arrays.asList(plots));
    }

    public static Plot[] leftAndRightMostPlot(Application dom, List<Plot> plots) {
        Column r;
        Plot pmax = plots.get(0);
        Plot pmin = plots.get(0);
        Column rmax = r = (Column)DomUtil.getElementById(dom.getCanvases(0), pmax.getColumnId());
        Column rmin = r;
        for (Plot p : plots) {
            r = (Column)DomUtil.getElementById(dom.getCanvases(0), p.getColumnId());
            if (r.getController().getDasColumn().getDMaximum() > rmax.getController().getDasColumn().getDMaximum()) {
                rmax = r;
                pmax = p;
            }
            if (r.getController().getDasColumn().getDMinimum() >= rmin.getController().getDasColumn().getDMinimum()) continue;
            rmin = r;
            pmin = p;
        }
        return new Plot[]{pmin, pmax};
    }

    public static Plot[] leftAndRightMostPlot(Application dom, Plot[] plots) {
        return DomOps.leftAndRightMostPlot(dom, Arrays.asList(plots));
    }

    public static List<Plot> getPlotsFor(Application dom, Row row, boolean visible) {
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Plot p : dom.getPlots()) {
            if (!p.getRowId().equals(row.getId())) continue;
            if (visible) {
                if (!p.isVisible()) continue;
                result.add(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    public static List<Plot> getPlotsFor(Application dom, Column column, boolean visible) {
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Plot p : dom.getPlots()) {
            if (!p.getColumnId().equals(column.getId())) continue;
            if (visible) {
                if (!p.isVisible()) continue;
                result.add(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    private static int lineCount(String s) {
        int emptyLines;
        String[] ss = s.split("(\\!c|\\!C|\\<br\\>)");
        for (emptyLines = 0; emptyLines < ss.length && ss[emptyLines].trim().length() == 0; ++emptyLines) {
        }
        return ss.length - emptyLines;
    }

    public static void newCanvasLayout(Application dom) {
        DomOps.fixLayout(dom, Collections.emptyMap());
    }

    public static void fixLayout(Application dom) {
        DomOps.fixLayout(dom, Collections.emptyMap());
    }

    private static double[] parseLayoutStr(String s, double[] deflt) {
        try {
            return DasDevicePosition.parseLayoutStr((String)s);
        }
        catch (ParseException ex) {
            return deflt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixLayout(Application dom, Map<String, String> options) {
        Logger logger = LoggerManager.getLogger((String)"autoplot.dom.layout.fixlayout");
        logger.fine("enter fixLayout");
        if (!dom.controller.changesSupport.mutatorLock().isLocked() && !SwingUtilities.isEventDispatchThread()) {
            dom.getController().waitUntilIdle();
        }
        boolean autoLayout = dom.options.isAutolayout();
        dom.options.setAutolayout(false);
        try {
            String leftColumnId;
            Canvas canvas = dom.getCanvases(0);
            Column marginColumn = canvas.getMarginColumn();
            Row[] rows = canvas.getRows();
            int nrow = rows.length;
            Column[] columns = canvas.getColumns();
            HashMap<String, Row> rowsCheck = new HashMap<String, Row>();
            ArrayList<Row> rm = new ArrayList<Row>();
            for (int i = 0; i < nrow; ++i) {
                List<Plot> plots = DomOps.getPlotsFor(dom, rows[i], true);
                if (plots.size() > 0) {
                    if (rowsCheck.containsKey(rows[i].getId())) {
                        logger.log(Level.FINE, "duplicate row id: {0}", rows[i].getId());
                        rm.add(rows[i]);
                        continue;
                    }
                    rowsCheck.put(rows[i].getId(), rows[i]);
                    continue;
                }
                logger.log(Level.FINE, "unused row: {0}", rows[i]);
                rm.add(rows[i]);
            }
            ArrayList<Row> rowsList = new ArrayList<Row>(Arrays.asList(rows));
            rm.forEach(r -> rowsList.remove(r));
            canvas.setRows(rowsList.toArray(new Row[rowsList.size()]));
            rows = new Row[rowsList.size()];
            nrow = rows.length;
            for (int i = 0; i < nrow; ++i) {
                rows[i] = new Row();
                rows[i].syncTo(canvas.getRows(i));
            }
            Arrays.sort(rows, (r1, r2) -> {
                int d1 = DomUtil.getRowPositionPixels(dom, r1, r1.getTop());
                int d2 = DomUtil.getRowPositionPixels(dom, r2, r2.getTop());
                return d1 - d2;
            });
            String topRowId = rows[0].getId();
            String bottomRowId = rows[rows.length - 1].getId();
            String string = leftColumnId = columns.length > 0 ? columns[0].getId() : "";
            if (options.getOrDefault(OPTION_FIX_LAYOUT_HIDE_TITLES, "false").equals("true")) {
                for (Plot p : dom.plots) {
                    if (p.getRowId().equals(topRowId)) {
                        logger.fine("not hiding top plot's title");
                        continue;
                    }
                    p.setDisplayTitle(false);
                }
            }
            if (options.getOrDefault(OPTION_FIX_LAYOUT_HIDE_TIME_AXES, "false").equals("true")) {
                for (Plot p : dom.plots) {
                    if (p.getRowId().equals(bottomRowId)) {
                        logger.fine("not hiding bottom plot's time axis");
                        continue;
                    }
                    p.xaxis.setDrawTickLabels(false);
                }
            }
            if (options.getOrDefault(OPTION_FIX_LAYOUT_HIDE_Y_AXES, "false").equals("true") && columns.length != 0) {
                for (Plot p : dom.plots) {
                    if (p.getColumnId().equals(leftColumnId) || p.getColumnId().equals(marginColumn.getId())) {
                        logger.fine("not hiding leftmost plot's Y axis");
                        continue;
                    }
                    p.yaxis.setDrawTickLabels(false);
                }
            }
            if (options.getOrDefault(OPTION_FIX_LAYOUT_MOVE_LEGENDS_TO_OUTSIDE_NE, "false").equals("true")) {
                for (Plot p : dom.plots) {
                    if (!p.isDisplayLegend() || p.getZaxis().isVisible()) continue;
                    p.setLegendPosition(LegendPosition.OutsideNE);
                }
            }
            DomOps.fixVerticalLayout(dom, options);
            DomOps.fixHorizontalLayout(dom, options);
        }
        finally {
            dom.options.setAutolayout(autoLayout);
        }
        if (!dom.controller.changesSupport.mutatorLock().isLocked() && !SwingUtilities.isEventDispatchThread()) {
            dom.getController().waitUntilIdle();
        }
    }

    private static int getXAxisLines(Plot plotj) {
        int ephemerisLineCount;
        if (!plotj.getXaxis().isDrawTickLabels()) {
            return 1;
        }
        int lc = DomOps.lineCount(plotj.getXaxis().getLabel());
        if (plotj.getEphemerisLineCount() > -1) {
            ephemerisLineCount = plotj.getEphemerisLineCount();
        } else if (plotj.getTicksURI().trim().length() > 0) {
            if (plotj.getXaxis().getController() != null) {
                DasAxis a = plotj.getXaxis().getController().getDasAxis();
                ephemerisLineCount = a.getTickLines();
            } else {
                ephemerisLineCount = 5;
            }
        } else {
            if (lc == 0) {
                lc = 1;
            }
            ephemerisLineCount = 0;
        }
        ephemerisLineCount = (int)((double)ephemerisLineCount + Math.ceil((double)ephemerisLineCount / 4.0));
        return ephemerisLineCount + 2 + 1 + lc;
    }

    public static void fixVerticalLayout(Application dom) {
        DomOps.fixVerticalLayout(dom, Collections.emptyMap());
    }

    public static void fixVerticalLayout(Application dom, Map<String, String> options) {
        int i;
        int i2;
        double marginHeight;
        int i3;
        int i4;
        int i5;
        Pattern p;
        Canvas canvas = dom.getCanvases(0);
        Row marginRow = (Row)canvas.getMarginRow().copy();
        double emToPixels = Font.decode(dom.getCanvases((int)0).font).getSize();
        Row[] rows = canvas.getRows();
        int nrow = rows.length;
        for (int i6 = 0; i6 < rows.length; ++i6) {
            rows[i6] = (Row)rows[i6].copy();
        }
        boolean[] doAdjust = new boolean[nrow];
        String topRowId = rows[0].getId();
        String bottomRowId = rows[rows.length - 1].getId();
        double[] MaxUp = new double[nrow];
        double[] MaxDown = new double[nrow];
        double[] MaxUpEm = new double[nrow];
        double[] MaxDownEm = new double[nrow];
        String verticalSpacing = options.getOrDefault(OPTION_FIX_LAYOUT_VERTICAL_SPACING, "");
        if (verticalSpacing.trim().length() > 0 && (p = Pattern.compile("([0-9\\.]*)em")).matcher(verticalSpacing).matches()) {
            Double d = Double.parseDouble(verticalSpacing.substring(0, verticalSpacing.length() - 2));
            double extraEms = 0.0;
            for (i5 = 0; i5 < MaxDown.length; ++i5) {
                double[] dd2;
                MaxUp[i5] = 0.0;
                MaxDown[i5] = -d.doubleValue() * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(rows[i5].top, new double[]{0.0, 0.0, 0.0});
                if (dd1[0] == (dd2 = DomOps.parseLayoutStr(rows[i5].bottom, new double[]{0.0, 0.0, 0.0}))[0]) {
                    double h = dd2[1] - dd1[1];
                    dd1[1] = extraEms;
                    dd2[1] = extraEms + h;
                    extraEms += h + d;
                } else {
                    dd1[1] = extraEms;
                    dd2[1] = extraEms - d;
                }
                rows[i5].top = DasDevicePosition.formatLayoutStr((double[])dd1);
                rows[i5].bottom = DasDevicePosition.formatLayoutStr((double[])dd2);
            }
        }
        double ntopEm = 0.0;
        double nbottomEm = 0.0;
        for (i5 = 0; i5 < dom.plots.size(); ++i5) {
            Plot p2 = dom.plots.get(i5);
            if (p2.getRowId().equals(topRowId)) {
                ntopEm = Math.max(ntopEm, (double)DomOps.lineCount(p2.getTitle()));
            }
            if (!p2.getRowId().equals(bottomRowId)) continue;
            nbottomEm = Math.max(nbottomEm, (double)DomOps.getXAxisLines(p2));
        }
        marginRow.setTop(DasDevicePosition.formatLayoutStr((double[])new double[]{0.0, ntopEm + 2.0, 0.0}));
        marginRow.setBottom(DasDevicePosition.formatLayoutStr((double[])new double[]{1.0, -(nbottomEm + 2.0), 0.0}));
        double[] resizablePixels = new double[nrow];
        boolean[] isEmRow = new boolean[nrow];
        double[] emsUpSize = new double[nrow];
        double[] emsDownSize = new double[nrow];
        logger.log(Level.FINER, "1. new settings for the margin row:{0} {1}", new Object[]{marginRow.getTop(), marginRow.getBottom()});
        for (i4 = 0; i4 < nrow; ++i4) {
            double[] rr2;
            double[] rr1 = DomOps.parseLayoutStr(rows[i4].getTop(), new double[3]);
            isEmRow[i4] = Math.abs(rr1[0] - (rr2 = DomOps.parseLayoutStr(rows[i4].getBottom(), new double[3]))[0]) < 0.001;
            emsUpSize[i4] = rr1[1];
            emsDownSize[i4] = rr2[1];
            if (isEmRow[i4]) {
                MaxDownEm[i4] = emsDownSize[i4];
                MaxUpEm[i4] = emsUpSize[i4];
                MaxDown[i4] = emsDownSize[i4] * emToPixels;
                MaxUp[i4] = emsUpSize[i4] * emToPixels;
                doAdjust[i4] = true;
                continue;
            }
            List<Plot> plots = DomOps.getPlotsFor(dom, rows[i4], true);
            for (Plot plotj : plots) {
                if (rows[i4].parent.equals(marginRow.id)) {
                    String title;
                    String content = title = plotj.getTitle();
                    boolean addLines = plotj.isDisplayTitle() && content.trim().length() > 0;
                    int lc = DomOps.lineCount(title);
                    double MaxUpJEm = rows[i4].id.equals(topRowId) ? (addLines ? (double)lc : 0.0) - ntopEm : (addLines ? (double)lc : 0.0);
                    MaxUp[i4] = Math.max(MaxUp[i4], MaxUpJEm * emToPixels);
                    MaxUpEm[i4] = Math.max(MaxUpEm[i4], MaxUpJEm);
                    MaxDownEm[i4] = rows[i4].id.equals(bottomRowId) ? Math.min(MaxDownEm[i4], 0.0) : Math.min(MaxDownEm[i4], (double)(-DomOps.getXAxisLines(plotj)));
                    MaxDown[i4] = MaxDownEm[i4] * emToPixels;
                    doAdjust[i4] = true;
                    continue;
                }
                doAdjust[i4] = false;
            }
            if (verticalSpacing.trim().length() <= 0) continue;
            MaxDownEm[i4] = emsDownSize[i4] - emsUpSize[i4];
            MaxUpEm[i4] = 0.0;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "2. space needed to the top and bottom of each plot:");
            for (i4 = 0; i4 < nrow; ++i4) {
                logger.log(Level.FINER, "  {0}em {1}em", new Object[]{MaxUpEm[i4], MaxDownEm[i4]});
            }
        }
        if (rows.length > 1) {
            int last;
            boolean adjust = true;
            double em = MaxUpEm[1];
            for (int i7 = 2; i7 < rows.length; ++i7) {
                if (em == MaxUpEm[i7]) continue;
                adjust = false;
            }
            if (adjust && MaxUpEm[0] != em) {
                double toMarginEms = MaxUpEm[0] - em;
                MaxUpEm[0] = em;
                MaxUp[0] = em * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(marginRow.top, new double[]{0.0, 0.0, 0.0});
                dd1[1] = dd1[1] + toMarginEms;
                marginRow.top = DasDevicePosition.formatLayoutStr((double[])dd1);
            }
            adjust = true;
            em = MaxDownEm[0];
            for (int i8 = 0; i8 < rows.length - 1; ++i8) {
                if (em == MaxDownEm[i8]) continue;
                adjust = false;
            }
            if (adjust && MaxDownEm[last = MaxDownEm.length - 1] != em) {
                double toMarginEms = MaxUpEm[0] - em;
                MaxDownEm[last] = em;
                MaxDown[last] = em * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(marginRow.bottom, new double[]{0.0, 0.0, 0.0});
                dd1[1] = -toMarginEms;
                marginRow.bottom = DasDevicePosition.formatLayoutStr((double[])dd1);
            }
        }
        double totalPlotHeightPixels = 0.0;
        for (int i9 = 0; i9 < nrow; ++i9) {
            List<Plot> plots = DomOps.getPlotsFor(dom, rows[i9], true);
            if (plots.size() <= 0) continue;
            int d1 = DomUtil.getRowPositionPixels(dom, rows[i9], rows[i9].getTop());
            int d2 = DomUtil.getRowPositionPixels(dom, rows[i9], rows[i9].getBottom());
            resizablePixels[i9] = d2 - d1;
            if (isEmRow[i9]) {
                logger.fine("here's an events bar row!");
                continue;
            }
            totalPlotHeightPixels += resizablePixels[i9];
        }
        logger.log(Level.FINER, "3. number of pixels used by plots which are resizable: {0}", totalPlotHeightPixels);
        double[] relativePlotHeight = new double[nrow];
        for (i3 = 0; i3 < nrow; ++i3) {
            relativePlotHeight[i3] = isEmRow[i3] ? 0.0 : resizablePixels[i3] / totalPlotHeightPixels;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("4. relative sizes of the rows: ");
            for (i3 = 0; i3 < nrow; ++i3) {
                logger.log(Level.FINER, "  {0}", relativePlotHeight[i3]);
            }
        }
        int d1 = DomUtil.getRowPositionPixels(dom, marginRow, marginRow.top);
        int d2 = DomUtil.getRowPositionPixels(dom, marginRow, marginRow.bottom);
        double newPlotTotalHeightPixels = marginHeight = (double)(d2 - d1);
        for (int i10 = 0; i10 < nrow; ++i10) {
            newPlotTotalHeightPixels = newPlotTotalHeightPixels - MaxUp[i10] + MaxDown[i10];
        }
        logger.log(Level.FINER, "5. number of pixels available to the plots which can resize: {0}", newPlotTotalHeightPixels);
        double[] newPlotHeightPixels = new double[nrow];
        for (i2 = 0; i2 < nrow; ++i2) {
            newPlotHeightPixels[i2] = newPlotTotalHeightPixels * relativePlotHeight[i2];
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("6. new resizable plot heights in pixels: ");
            for (i2 = 0; i2 < nrow; ++i2) {
                logger.log(Level.FINER, "  {0}", newPlotHeightPixels[i2]);
            }
        }
        double[] normalPlotHeight = new double[nrow];
        if (nrow == 1) {
            normalPlotHeight[0] = newPlotHeightPixels[0] / marginHeight;
        } else {
            for (int i11 = 0; i11 < nrow; ++i11) {
                normalPlotHeight[i11] = relativePlotHeight[i11] == 0.0 ? 0.0 : (newPlotHeightPixels[i11] + MaxUp[i11] - MaxDown[i11]) / marginHeight;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("7. new plot heights, which also include the em offsets: ");
            for (int i12 = 0; i12 < nrow; ++i12) {
                logger.log(Level.FINER, "  {0}", normalPlotHeight[i12]);
            }
        }
        double position = 0.0;
        double extraEms = 0.0;
        double nominalSpacingEms = -MaxDownEm[0] + MaxUpEm[0];
        for (i = 0; i < nrow; ++i) {
            if (doAdjust[i]) {
                String newBottom;
                String newTop;
                if (!isEmRow[i]) {
                    newTop = DasDevicePosition.formatLayoutStr((double[])new double[]{position, MaxUpEm[i] + extraEms, 0.0});
                    newBottom = DasDevicePosition.formatLayoutStr((double[])new double[]{position += normalPlotHeight[i], MaxDownEm[i] + extraEms, 0.0});
                } else {
                    newTop = DasDevicePosition.formatLayoutStr((double[])new double[]{position, MaxUpEm[i] + extraEms, 0.0});
                    newBottom = DasDevicePosition.formatLayoutStr((double[])new double[]{position, MaxDownEm[i] + extraEms, 0.0});
                    if (verticalSpacing.trim().length() > 0) {
                        logger.finer("we already accounted for this.");
                    } else {
                        extraEms += nominalSpacingEms + (MaxDownEm[i] + MaxUpEm[i]);
                    }
                }
                rows[i].setTop(newTop);
                rows[i].setBottom(newBottom);
                if (!logger.isLoggable(Level.FINE)) continue;
                int r0 = DomUtil.getRowPositionPixels(dom, rows[i], rows[i].getTop());
                int r1 = DomUtil.getRowPositionPixels(dom, rows[i], rows[i].getBottom());
                logger.log(Level.FINE, "row {0}: {1},{2} ({3} pixels)", new Object[]{i, newTop, newBottom, r1 - r0});
                continue;
            }
            logger.log(Level.FINE, "row {0} is not adjusted", i);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("8. new layout strings: ");
            for (i = 0; i < nrow; ++i) {
                logger.log(Level.FINER, "  {0} {1}", new Object[]{rows[i].getTop(), rows[i].getBottom()});
            }
        }
        for (i = 0; i < rows.length; ++i) {
            canvas.getRows(i).syncTo(rows[i]);
        }
        dom.getCanvases(0).getMarginRow().syncTo(marginRow);
    }

    public static void fixHorizontalLayout(Application dom) {
        DomOps.fixHorizontalLayout(dom, Collections.emptyMap());
    }

    public static void fixHorizontalLayout(Application dom, Map<String, String> options) {
        int i;
        int i2;
        int i3;
        double marginWidth;
        int i4;
        int i5;
        int i6;
        Pattern p;
        Logger logger = LoggerManager.getLogger((String)"autoplot.dom.layout.fixlayout");
        logger.fine("enter fixHorizontalLayout");
        Canvas canvas = dom.getCanvases(0);
        Column marginColumn = (Column)canvas.getMarginColumn().copy();
        double emToPixels = Font.decode(dom.getCanvases((int)0).font).getSize();
        Column[] columns = canvas.getColumns();
        int ncolumn = columns.length;
        boolean[] doAdjust = new boolean[ncolumn];
        HashMap<String, Column> columnCheck = new HashMap<String, Column>();
        ArrayList<Column> rm = new ArrayList<Column>();
        for (int i7 = 0; i7 < ncolumn; ++i7) {
            List<Plot> plots = DomOps.getPlotsFor(dom, columns[i7], true);
            if (plots.size() > 0) {
                if (columnCheck.containsKey(columns[i7].getId())) {
                    logger.log(Level.FINE, "duplicate row id: {0}", columns[i7].getId());
                    rm.add(columns[i7]);
                    continue;
                }
                columnCheck.put(columns[i7].getId(), columns[i7]);
                continue;
            }
            logger.log(Level.FINE, "unused row: {0}", columns[i7]);
            rm.add(columns[i7]);
        }
        ArrayList<Column> columnsList = new ArrayList<Column>(Arrays.asList(columns));
        rm.forEach(r -> columnsList.remove(r));
        HashMap<Column, Column> replace = new HashMap<Column, Column>();
        ncolumn = columnsList.size();
        for (int i8 = 0; i8 < ncolumn; ++i8) {
            Column c = columnsList.get(i8);
            for (int j = i8 + 1; j < ncolumn; ++j) {
                Column nj = columnsList.get(j);
                if (nj == c || !c.left.equals(nj.left) || !c.right.equals(nj.right) || !c.parent.equals(nj.parent)) continue;
                replace.put(nj, c);
            }
        }
        for (Map.Entry rm1 : replace.entrySet()) {
            for (Plot p2 : dom.plots) {
                if (!p2.getColumnId().equals(((Column)rm1.getKey()).id)) continue;
                p2.setColumnId(((Column)rm1.getValue()).id);
            }
            for (Annotation ann : dom.annotations) {
                if (!ann.getColumnId().equals(((Column)rm1.getKey()).id)) continue;
                ann.setColumnId(((Column)rm1.getValue()).id);
            }
            columnsList.remove(rm1.getKey());
        }
        canvas.setColumns(columnsList.toArray(new Column[columnsList.size()]));
        columns = new Column[columnsList.size()];
        ncolumn = columns.length;
        for (int i9 = 0; i9 < ncolumn; ++i9) {
            columns[i9] = new Column();
            columns[i9].syncTo(canvas.getColumns(i9));
        }
        Arrays.sort(columns, (c1, c2) -> {
            int d1 = DomUtil.getColumnPositionPixels(dom, c1, c1.getLeft());
            int d2 = DomUtil.getColumnPositionPixels(dom, c2, c2.getLeft());
            return d1 - d2;
        });
        String leftColumnId = ncolumn > 0 ? columns[0].id : "";
        String rightColumnId = ncolumn > 0 ? columns[columns.length - 1].id : "";
        String horizontalSpacing = options.getOrDefault(OPTION_FIX_LAYOUT_HORIZONTAL_SPACING, "");
        double[] MaxLeft = new double[ncolumn];
        double[] MaxRight = new double[ncolumn];
        double[] MaxLeftEm = new double[ncolumn];
        double[] MaxRightEm = new double[ncolumn];
        if (horizontalSpacing.trim().length() > 0 && (p = Pattern.compile("([0-9\\.]*)em")).matcher(horizontalSpacing).matches()) {
            Double d = Double.parseDouble(horizontalSpacing.substring(0, horizontalSpacing.length() - 2));
            double extraEms = 0.0;
            for (i6 = 0; i6 < MaxRight.length; ++i6) {
                double[] dd2;
                MaxLeft[i6] = 0.0;
                MaxRight[i6] = -d.doubleValue() * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(columns[i6].left, new double[]{0.0, 0.0, 0.0});
                if (dd1[0] == (dd2 = DomOps.parseLayoutStr(columns[i6].right, new double[]{0.0, 0.0, 0.0}))[0]) {
                    double h = dd2[1] - dd1[1];
                    dd1[1] = extraEms;
                    dd2[1] = extraEms + h;
                    extraEms += h + d;
                } else {
                    dd1[1] = extraEms;
                    dd2[1] = extraEms - d;
                }
                columns[i6].left = DasDevicePosition.formatLayoutStr((double[])dd1);
                columns[i6].right = DasDevicePosition.formatLayoutStr((double[])dd2);
                logger.log(Level.FINE, "line986: {0},{1}", new Object[]{columns[i6].left, columns[i6].right});
            }
        }
        double nleftEm = 0.0;
        double nrightEm = 0.0;
        for (i6 = 0; i6 < dom.plots.size(); ++i6) {
            Plot p3 = dom.plots.get(i6);
            if (p3.getColumnId().equals(leftColumnId) || p3.getColumnId().equals(marginColumn.id)) {
                nleftEm = Math.max(nleftEm, (double)(DomOps.lineCount(p3.getYaxis().getLabel()) + 5));
            }
            if (!p3.getColumnId().equals(rightColumnId) && !p3.getColumnId().equals(marginColumn.id)) continue;
            nrightEm = p3.getZaxis().isVisible() ? Math.max(nrightEm, 14.0) : Math.max(nrightEm, 8.0);
            if (!p3.isDisplayLegend() || p3.getLegendPosition() != LegendPosition.OutsideNE && p3.getLegendPosition() != LegendPosition.OutsideSE) continue;
            double arbitaryRightEms = 13.0;
            nrightEm = Math.max(nrightEm, arbitaryRightEms);
        }
        if (ncolumn > 0) {
            nrightEm = 0.0;
        }
        marginColumn.setLeft(DasDevicePosition.formatLayoutStr((double[])new double[]{0.0, nleftEm + 2.0, 0.0}));
        marginColumn.setRight(DasDevicePosition.formatLayoutStr((double[])new double[]{1.0, -nrightEm, 0.0}));
        if (ncolumn == 0) {
            logger.finer("0. No adjustable columns, returning!");
            return;
        }
        double[] resizablePixels = new double[ncolumn];
        boolean[] isEmColumn = new boolean[ncolumn];
        double[] emsLeftSize = new double[ncolumn];
        double[] emsRightSize = new double[ncolumn];
        logger.log(Level.FINER, "1. new settings for the margin column:{0} {1}", new Object[]{marginColumn.getLeft(), marginColumn.getRight()});
        for (i5 = 0; i5 < ncolumn; ++i5) {
            double[] rr2;
            double[] rr1 = DomOps.parseLayoutStr(columns[i5].getLeft(), new double[3]);
            isEmColumn[i5] = Math.abs(rr1[0] - (rr2 = DomOps.parseLayoutStr(columns[i5].getRight(), new double[3]))[0]) < 0.001;
            emsLeftSize[i5] = rr1[1];
            emsRightSize[i5] = rr2[1];
            if (isEmColumn[i5]) {
                MaxRightEm[i5] = emsRightSize[i5];
                MaxLeftEm[i5] = emsLeftSize[i5];
                MaxRight[i5] = emsRightSize[i5] * emToPixels;
                MaxLeft[i5] = emsLeftSize[i5] * emToPixels;
                doAdjust[i5] = true;
                continue;
            }
            List<Plot> plots = DomOps.getPlotsFor(dom, columns[i5], true);
            for (Plot plotj : plots) {
                if (columns[i5].parent.equals(marginColumn.id)) {
                    String label = plotj.getYaxis().getLabel();
                    boolean addLines = plotj.getYaxis().isDrawTickLabels();
                    int lc = DomOps.lineCount(label);
                    int lcPlusTicks = lc + 4;
                    double MaxLeftJEm = addLines ? (double)lcPlusTicks : 0.0;
                    MaxLeft[i5] = Math.max(MaxLeft[i5], MaxLeftJEm * emToPixels);
                    MaxLeftEm[i5] = Math.max(MaxLeftEm[i5], MaxLeftJEm);
                    double nnrightEm = plotj.getZaxis().isVisible() ? -4.0 : -1.0;
                    if ((plotj.getLegendPosition() == LegendPosition.OutsideNE || plotj.getLegendPosition() == LegendPosition.OutsideSE) && plotj.isDisplayLegend()) {
                        double legendWidthEms = -8.0;
                        nnrightEm = Math.min(nnrightEm, legendWidthEms);
                    }
                    MaxRightEm[i5] = Math.min(MaxRightEm[i5], nnrightEm);
                    MaxRight[i5] = MaxRightEm[i5] * emToPixels;
                    doAdjust[i5] = true;
                    continue;
                }
                doAdjust[i5] = false;
            }
            if (horizontalSpacing.trim().length() <= 0) continue;
            MaxRightEm[i5] = emsRightSize[i5] - emsLeftSize[i5];
            MaxLeftEm[i5] = 0.0;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "2. space needed to the right and left of each plot:");
            for (i5 = 0; i5 < ncolumn; ++i5) {
                logger.log(Level.FINER, "  {0}em {1}em", new Object[]{MaxLeftEm[i5], MaxRightEm[i5]});
            }
        }
        if (columns.length > 1) {
            int last;
            boolean adjust = true;
            double em = MaxLeftEm[1];
            for (int i10 = 2; i10 < columns.length; ++i10) {
                if (em == MaxLeftEm[i10]) continue;
                adjust = false;
            }
            if (adjust && MaxLeftEm[0] != em) {
                double toMarginEms = MaxLeftEm[0] - em;
                MaxLeftEm[0] = em;
                MaxLeft[0] = em * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(marginColumn.left, new double[]{0.0, 0.0, 0.0});
                dd1[1] = toMarginEms;
                marginColumn.left = DasDevicePosition.formatLayoutStr((double[])dd1);
            }
            adjust = true;
            em = MaxRightEm[0];
            for (int i11 = 0; i11 < columns.length - 1; ++i11) {
                if (em == MaxRightEm[i11]) continue;
                adjust = false;
            }
            if (adjust && MaxRightEm[last = MaxRightEm.length - 1] != em) {
                double toMarginEms = MaxRightEm[0] - em;
                MaxRightEm[last] = em;
                MaxRight[last] = em * emToPixels;
                double[] dd1 = DomOps.parseLayoutStr(marginColumn.right, new double[]{0.0, 0.0, 0.0});
                dd1[1] = dd1[1] + toMarginEms;
                marginColumn.right = DasDevicePosition.formatLayoutStr((double[])dd1);
            }
        }
        double totalPlotWidthPixels = 0.0;
        for (int i12 = 0; i12 < ncolumn; ++i12) {
            List<Plot> plots = DomOps.getPlotsFor(dom, columns[i12], true);
            if (plots.size() <= 0) continue;
            int d1 = DomUtil.getColumnPositionPixels(dom, columns[i12], columns[i12].getLeft());
            int d2 = DomUtil.getColumnPositionPixels(dom, columns[i12], columns[i12].getRight());
            resizablePixels[i12] = d2 - d1;
            if (isEmColumn[i12]) {
                logger.fine("here's a fixed-width column!");
                continue;
            }
            totalPlotWidthPixels += resizablePixels[i12];
        }
        logger.log(Level.FINER, "3. number of pixels used by plots which are resizable: {0}", totalPlotWidthPixels);
        double[] relativePlotWidth = new double[ncolumn];
        for (i4 = 0; i4 < ncolumn; ++i4) {
            relativePlotWidth[i4] = isEmColumn[i4] ? 0.0 : resizablePixels[i4] / totalPlotWidthPixels;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("4. relative sizes of the rows: ");
            for (i4 = 0; i4 < ncolumn; ++i4) {
                logger.log(Level.FINER, "  {0}", relativePlotWidth[i4]);
            }
        }
        double canvasWidth = canvas.width;
        int d1 = DomUtil.getColumnPositionPixels(dom, marginColumn, marginColumn.left);
        int d2 = DomUtil.getColumnPositionPixels(dom, marginColumn, marginColumn.right);
        double newPlotTotalWidthPixels = marginWidth = (double)(d2 - d1);
        for (int i13 = 0; i13 < ncolumn; ++i13) {
            newPlotTotalWidthPixels = newPlotTotalWidthPixels - MaxLeft[i13] + MaxRight[i13];
        }
        logger.log(Level.FINER, "5. number of pixels available to the plots which can resize: {0}", newPlotTotalWidthPixels);
        double[] newPlotWidthPixels = new double[ncolumn];
        for (i3 = 0; i3 < ncolumn; ++i3) {
            newPlotWidthPixels[i3] = newPlotTotalWidthPixels * relativePlotWidth[i3];
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("6. new resizable plot widths in pixels: ");
            for (i3 = 0; i3 < ncolumn; ++i3) {
                logger.log(Level.FINER, "  {0}", newPlotWidthPixels[i3]);
            }
        }
        double[] normalPlotWidth = new double[ncolumn];
        if (ncolumn == 1) {
            normalPlotWidth[0] = newPlotWidthPixels[0] / marginWidth;
        } else {
            for (i2 = 0; i2 < ncolumn; ++i2) {
                normalPlotWidth[i2] = relativePlotWidth[i2] == 0.0 ? 0.0 : (newPlotWidthPixels[i2] + MaxLeft[i2] - MaxRight[i2]) / marginWidth;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("7. new plot widths, which also include the em offsets: ");
            for (i2 = 0; i2 < ncolumn; ++i2) {
                logger.log(Level.FINER, "  {0}", normalPlotWidth[i2]);
            }
        }
        double position = 0.0;
        double extraEms = 0.0;
        double nominalSpacingEms = -MaxRightEm[0] + MaxLeftEm[0];
        for (i = 0; i < ncolumn; ++i) {
            if (doAdjust[i]) {
                String newRight;
                String newLeft;
                if (!isEmColumn[i]) {
                    newLeft = DasDevicePosition.formatLayoutStr((double[])new double[]{position, MaxLeftEm[i] + extraEms, 0.0});
                    newRight = DasDevicePosition.formatLayoutStr((double[])new double[]{position += normalPlotWidth[i], MaxRightEm[i] + extraEms, 0.0});
                } else {
                    newLeft = DasDevicePosition.formatLayoutStr((double[])new double[]{position, 100.0 * position, MaxLeftEm[i] + extraEms, 0.0});
                    newRight = DasDevicePosition.formatLayoutStr((double[])new double[]{position, 100.0 * position, MaxRightEm[i] + extraEms, 0.0});
                    if (horizontalSpacing.trim().length() > 0) {
                        logger.finest("we already accounted for this.");
                    } else {
                        extraEms += nominalSpacingEms + (MaxRightEm[i] + MaxLeftEm[i]);
                    }
                }
                columns[i].setLeft(newLeft);
                columns[i].setRight(newRight);
                if (!logger.isLoggable(Level.FINE)) continue;
                int r0 = DomUtil.getColumnPositionPixels(dom, columns[i], columns[i].getLeft());
                int n = DomUtil.getColumnPositionPixels(dom, columns[i], columns[i].getRight());
                continue;
            }
            logger.log(Level.FINEST, "row {0} is not adjusted", i);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("8. new layout strings: ");
            for (i = 0; i < ncolumn; ++i) {
                logger.log(Level.FINER, "  {0} {1}", new Object[]{columns[i].getLeft(), columns[1].getRight()});
            }
        }
        for (i = 0; i < columns.length; ++i) {
            canvas.getColumns(i).syncTo(columns[i]);
        }
        canvas.getMarginColumn().syncTo(marginColumn);
        logger.log(Level.FINEST, "done");
    }

    public static void aggregateAll(Application dom) {
        DataSourceFilter[] dsfs;
        Application oldDom = (Application)dom.copy();
        for (DataSourceFilter dsf : dsfs = dom.getDataSourceFilters()) {
            String agg;
            if (dsf.uri == null || dsf.uri.length() == 0 || dsf.uri.startsWith("vap+internal:") || (agg = DataSourceUtil.makeAggregation((String)dsf.uri)) == null) continue;
            dsf.setUri(agg);
        }
        dom.setDataSourceFilters(dsfs);
        dom.syncTo(oldDom, Collections.singletonList("dataSourceFilters"));
    }
}

